#!/bin/bash
#PBS -l nodes=1:ppn=8
##PBS -l mem=100gb
#PBS -l walltime=10:00:00
#PBS -d ./
#PBS -j oe

start=`date +%s`

CPU=$PBS_NP
if [ ! $CPU ]; then
   CPU=2
fi

N=$PBS_ARRAYID
if [ ! $N ]; then
    N=1
fi

#----------------
ctg=`ls *.R1_unmatch_genome.fa | head -n $N | tail -n 1`
prefix=${ctg.R1_unmatch_genome.fa}
program='/public1/home/miyj/sars/fig1/1C/dict-fa-total.py'
program2='/public1/home/miyj/sars/fig1/1C/length_AUCG.py'
genome='/public1//home/miyj/sars/fig4/SARS-COVID.fa'
echo "CPU= $CPU"
echo "FILE= $ctg"
echo "FILE_PREFIX= $prefix"
####bowtie SARS genome obtain 21-23nt bam
#if [ ! -e ${prefix} ]; then
   echo "bowtie prepare"
   source activate
   conda deactivate   
   conda activate smallRNA
   python $program $ctg ${prefix}.fa
   seqkit rename ${prefix}.fa > ${prefix}_total.fa
   bowtie-build $genome genome
   bowtie -f -v 1 -k 10 -t -p $CPU genome ${prefix}_total.fa -S ${prefix}.sam
   rm ${prefix}.fa ${prefix}_total.fa
   echo "bowtie finished"
   samtools view -bS -F 4 ${prefix}.sam >${prefix}_total.bam
   samtools sort -m 500M -@ $CPU -o ${prefix}_total.sort.bam ${prefix}_toal.bam
   samtools index  ${prefix}_total.sort.bam
   samtools view -f 16 -b -o ${prefix}_fu.bam  ${prefix}_total.sort.bam
   samtools view -F 16 -b -o ${prefix}_zheng.bam  ${prefix}_total.sort.bam
   bamToFastq -i ${prefix}_fu.bam -fq ${prefix}_fu.fq
   bamToFastq -i ${prefix}_zheng.bam -fq ${prefix}_zheng.fq
   seqkit fq2fa ${prefix}_fu.fq >${pre_fix}_fu.fa
   seqkit fq2fa ${prefix}_zheng.fq >${prefix}_zheng.fa
   python $program2 ${prefix}_fu.fa ${prefix}_fu_AUCG.txt
   python $program2 ${prefix}_zheng.fa ${prefix}_zheng_AUCG.txt
   
#fi

#----------------
end=`date +%s`
runtime=$((end-start))
h=$(($runtime/3600))
hh=$(($runtime%3600))
m=$(($hh/60))
s=$(($hh%60))

echo "Start= $start"
echo "End= $end"
echo "Run time= $h:$m:$s"
echo "Done!"

